<?php require_once("db.php"); ?>
<?php 
require_once("encoding.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$regex = <<<'END'
/
  (
    (?: [\x00-\x7F]                 # single-byte sequences   0xxxxxxx
    |   [\xC0-\xDF][\x80-\xBF]      # double-byte sequences   110xxxxx 10xxxxxx
    |   [\xE0-\xEF][\x80-\xBF]{2}   # triple-byte sequences   1110xxxx 10xxxxxx * 2
    |   [\xF0-\xF7][\x80-\xBF]{3}   # quadruple-byte sequence 11110xxx 10xxxxxx * 3 
    ){1,100}                        # ...one or more times
  )
| .                                 # anything else
/x
END;


class Core2
{
    public $dbh; // handle of the db connexion
    private static $instance;

    private function __construct()
    {
        // building data source name from config
        $dsn = 'mysql:host=' . Config2::read('db.host') .
               ';dbname='    . Config2::read('db.basename') .
               ';port='      . Config2::read('db.port') .
               ';connect_timeout=15';
        // getting DB user from config                
        $user = Config2::read('db.user');
        // getting DB password from config                
        $password = Config2::read('db.password');

        $this->dbh = new PDO($dsn, $user, $password);
    }

    public static function getInstance()
    {
        if (!isset(self::$instance))
        {
            $object = __CLASS__;
            self::$instance = new $object;
        }
        return self::$instance;
    }

    // others global functions
}
class Config2
{
    static $confArray;

    public static function read($name)
    {
        return self::$confArray[$name];
    }

    public static function write($name, $value)
    {
        self::$confArray[$name] = $value;
    }

}

Config2::write('db.host', 'localhost');
Config2::write('db.port', '3306');
Config2::write('db.basename', 'importch_rs2');
Config2::write('db.user', 'importch_imp');
Config2::write('db.password', 'NqzGT1)CHKX$');



	/* first we have to get all numbers and:
		client_id = auto!
		client_number = newch.from
		ag = newch.ag
		client name = newch.ns
		client_date = newch.pl
		last_edited = newch.date_change
		description = newch.txt
	*/
	
	$core = Core::getInstance();
	$stmt = $core -> dbh -> prepare("TRUNCATE myclients");
	$stmt -> execute();
	
	$core = Core::getInstance();
	$stmt = $core -> dbh -> prepare("TRUNCATE messages");
	$stmt -> execute();
	
	
	
	try {
		$core = Core2::getInstance();
		$stmt = $core->dbh->prepare("SELECT * FROM newch LEFT JOIN tbl_datepost ON `FROM` = user_id WHERE date_post >= NOW() - INTERVAL 180 DAY ORDER BY id ASC");
		//$stmt = $core->dbh->prepare("SELECT * FROM newch WHERE id = 506 ORDER BY id ASC");
		$stmt -> execute();
		$results = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		
		foreach ($results as $key => $value) {
			$client_number = $value["from"];
			$ag = $value["ag"];
			$client_name = Encoding::toUTF8($value["ns"], Encoding::ICONV_TRANSLIT);
			$client_date = $value["pl"];
			$last_edited = $value["date_change"];
			$date_post = $value["date_post"];
			$description = Encoding::toUTF8($value["txt"], Encoding::ICONV_TRANSLIT);
			
		
			
			$act = $value["act"];
			if ($act == "1") {
				// blokiran je
				$status = "0";
			} else {
				$status = "2";
			}
			
			// CHECK IF USER EXISTS!
			try {
			    $core = Core::getInstance();
			    $stmt_check = $core -> dbh -> prepare("SELECT * FROM myclients WHERE client_number = :client_number");
			    $stmt_check -> bindParam("client_number", $client_number, PDO::PARAM_STR);
			    $stmt_check -> execute();
			    $results_check_exists = $stmt_check ->fetchAll(PDO::FETCH_ASSOC);
			    $results_check_num = $stmt_check -> rowCount();
			} catch(PDOException $pe) {
				trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
			}
			
			// if user exists
			if ($results_check_num > 0) {
			    echo "postoji već".$client_number."<br />";
			    // compare dates!
			    $previous_datetime = date_create($results_check_exists["date_post"]);
			    $next_datetime = date_create($date_post);
			    
			    // if datetime is newer
			    if ($next_datetime > $previous_datetime) {
			        // we need to update ag!
			        $core = Core::getInstance();
			        $stmt_update = $core -> dbh -> prepare("UPDATE myclients SET ag = :ag");
			        $stmt_update -> bindParam("ag", $ag);
			        $stmt_update -> execute();
			    }
			} else {
			
    			// now import them!
    			try {
    				$core = Core::getInstance();
    				$stmt = $core -> dbh -> prepare("INSERT INTO myclients (client_number, client_name, client_date, last_edited, description, status, ag, date_post) VALUES (:client_number, :client_name, :client_date, :last_edited, :description, :status, :ag, :date_post)");
    				$stmt -> bindParam("client_number", $client_number, PDO::PARAM_STR);
    				$stmt -> bindParam("client_name", $client_name, PDO::PARAM_STR);
    				$stmt -> bindParam("client_date", $client_date);
    				$stmt -> bindParam("last_edited", $last_edited);
    				$stmt -> bindParam("description", $description);
    				$stmt -> bindParam("status", $status);
    				$stmt -> bindParam("ag", $ag);
    				$stmt -> bindParam("date_post", $date_post);
    				$stmt -> execute();
    				$client_id = $core->dbh->lastInsertId();
    			} catch(PDOException $pe) {
    				trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
    			}
			}
			
			
			
			// now fetch all messages related to that user and import them!!!
			try {
				$core = Core2::getInstance();
				$stmt = $core->dbh->prepare("SELECT * FROM tbl_chat WHERE user = :user or message_a like '%): ".$value["from"]."' AND date_post >= NOW() - INTERVAL 180 DAY ORDER BY date_post ASC");
				$stmt -> bindParam("user", $client_number);
				$stmt -> execute();
				$results_new = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			} catch(PDOException $pe) {
				trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
			}
			
			
			foreach($results_new as $key_new => $value_new) {
				$message = Encoding::toUTF8($value_new["message"], Encoding::ICONV_TRANSLIT);
				
				if (!preg_match('/^Agent/', $value_new["user"])) {
					$mess_whosent = "0";
					$mess_blk = "0";
					// treba unijeti odgovor od agenta!!!
					if ($value_new["message_a"] != "" && $value_new["date_send"] != "") {
						try {
							$core = Core::getInstance();
							$stmt = $core -> dbh -> prepare("INSERT INTO messages (mess_client_id, mess_message, mess_date, mess_whosent, mess_blk, mess_status) VALUES (:mess_client_id, :mess_message, :mess_date, '1', '0', '0')");
							$stmt -> bindParam("mess_client_id", $client_id, PDO::PARAM_INT);
							$stmt -> bindParam("mess_message", $value_new["message_a"], PDO::PARAM_STR);
							$stmt -> bindParam("mess_date", $value_new["date_send"]);
							$stmt -> execute();
						} catch(PDOException $pe) {
							trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
						}
					} else {
						//echo("ne postoji odgovor".$value_new["chat_id"]."<br />");
					}
					
				} else {
					$mess_whosent = "1";
					$mess_blk = "1";
				}
				try {
					$core = Core::getInstance();
					$stmt = $core -> dbh -> prepare("INSERT INTO messages (mess_client_id, mess_message, mess_date, mess_whosent, mess_blk, mess_status) VALUES (:mess_client_id, :mess_message, :mess_date, :mess_whosent, :mess_blk, '0')");
					$stmt -> bindParam("mess_client_id", $client_id, PDO::PARAM_INT);
					$stmt -> bindParam("mess_message", $message, PDO::PARAM_STR);
					$stmt -> bindParam("mess_date", $value_new["date_post"]);
					$stmt -> bindParam("mess_whosent", $mess_whosent);
					$stmt -> bindParam("mess_blk", $mess_blk);
					$stmt -> execute();
				} catch(PDOException $pe) {
					trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() . ' '.$client_id.'-'.$value_new["message"]. ' '.$value_new["chat_id"]. ' '.$message , E_USER_ERROR);
				}
			}
		}
		
	} catch(PDOException $pe) {
		trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
	}
	
	// update dates of users!
	
	try {
	    $core = Core2::getInstance();
		$stmt = $core->dbh->prepare("SELECT a.* FROM tbl_chat a INNER JOIN ( SELECT user, min(date_post) minDate FROM tbl_chat group by user) b on a.user = b.user AND a.date_post = b.minDate");
		$stmt -> execute();
		$results = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		
		foreach ($results as $key => $value) {
		    try {
    				$core = Core::getInstance();
    				$stmt = $core -> dbh -> prepare("UPDATE myclients SET date_in = :date_post WHERE client_number = :client_number");
    				$stmt -> bindParam("date_post", $value["date_post"], PDO::PARAM_STR);
    				$stmt -> bindParam("client_number", $value["user"], PDO::PARAM_STR);
    				$stmt -> execute();
    			} catch(PDOException $pe) {
    				trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
    			}
		}
	    
	} catch(PDOException $pe) {
		trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
	}
	
	/*
	$core = Core::getInstance();
	$stmt = $core -> dbh -> prepare("TRUNCATE messages");
	$stmt -> execute();
	
	try {
		$core = Core2::getInstance();
		$stmt = $core->dbh->prepare("SELECT * FROM tbl_chat ORDER BY id ASC");
		$stmt -> execute();
		$results = $stmt ->fetchAll(PDO::FETCH_ASSOC);
	} catch(PDOException $pe) {
		trigger_error('Could not connect to MySQL database. ' . $pe->getMessage() , E_USER_ERROR);
	}*/
?>